Attribute VB_Name = "Module1"
Option Explicit
Public Const e As Double = 2.71828182845905

Public Function GetRoots(x0 As Double, xf As Double, dx As Double, eps As Double) As Double()
    Dim x1 As Double, x2 As Double, f1 As Double, f2 As Double
    Dim rootsNo As Integer 'The number of roots
    Dim Roots() As Double: ReDim Roots(0)
    
    x1 = x0: f1 = f(x1)
    For x2 = x0 + dx To xf Step dx
        f2 = f(x2)
        If f1 * f2 <= 0 Then
            'There is a root
            rootsNo = rootsNo + 1
            ReDim Preserve Roots(rootsNo)
            Roots(rootsNo) = BiSectionMethod(x1, x2, eps)
        End If
        x1 = x2: f1 = f2
    Next
    GetRoots = Roots
End Function

Private Function BiSectionMethod(ByVal x1 As Double, ByVal x2 As Double, eps As Double) As Double
    Dim x0_5 As Double, f0_5 As Double
    Dim Root As Double
    
    If Abs(f(x1)) <= eps Then
        Root = x1
    ElseIf Abs(f(x2)) <= eps Then
        Root = x2
    Else
        x0_5 = (x1 + x2) / 2
        f0_5 = f(x0_5)
        If Abs(f0_5) <= eps Then
            Root = x0_5
        ElseIf f(x1) * f(x0_5) < 0 Then
            Root = BiSectionMethod(x1, x0_5, eps)
        Else
            Root = BiSectionMethod(x0_5, x2, eps)
        End If
    End If
    BiSectionMethod = Root
    
End Function

Public Function f(x As Double) As Double
    'f = Cos(x)
    f = 2 * Cos(x) - e ^ x
End Function
